package ru.yandex.chemodan.app.dataapi.api.data.record;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.IterableF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractDataRecords extends DefaultObject implements IterableF<DataRecord> {
    final MapF<DataRecordId, DataRecord> records;

    public AbstractDataRecords(ListF<DataRecord> records) {
        this(toMap(records));
    }

    protected AbstractDataRecords(MapF<DataRecordId, DataRecord> records) {
        this.records = records;
    }

    private static MapF<DataRecordId, DataRecord> toMap(CollectionF<DataRecord> records) {
        return Cf.x(
                records.stream().collect(
                        LinkedHashMap::new,
                        (map, record) -> map.put(record.id, record),
                        (BiConsumer<Map<DataRecordId, DataRecord>, Map<DataRecordId, DataRecord>>) Map::putAll)
        );
    }

    public SetF<DataRecordId> ids() {
        return records.keySet();
    }

    public CollectionF<DataRecord> records() {
        return records.values();
    }

    public DataRecord get(DataRecordId recordId) {
        return getO(recordId)
                .getOrThrow("No record with id = " + recordId);
    }

    public Option<DataRecord> getO(DataRecordId id) {
        return records.getO(id);
    }

    public int recordCount() {
        return records.size();
    }

    public boolean isEmpty() {
        return records.isEmpty();
    }

    public boolean isNotEmpty() {
        return records.isNotEmpty();
    }

    public boolean contains(DataRecordId recordId) {
        return records.containsKeyTs(recordId);
    }

    public long calcDataSize() {
        return records().map(DataRecord::getSize)
                .foldLeft(DataSize.ZERO, DataSize::plus)
                .toBytes();
    }

    @Override
    public IteratorF<DataRecord> iterator() {
        return records.values().iterator();
    }
}
