package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CollectionRef extends DefaultObject implements DatabaseRefSource {
    private final DatabaseRef dbRef;

    public final String collectionId;

    private CollectionRef(DatabaseRef dbRef, String collectionId) {
        this.dbRef = dbRef;
        this.collectionId = collectionId;
    }

    public static CollectionRef cons(DatabaseRef dbRef, String collectionId) {
        return new CollectionRef(dbRef, collectionId);
    }

    @Override
    public DatabaseRef dbRef() {
        return dbRef;
    }

    public String collectionId() {
        return collectionId;
    }

    public RecordRef consRecordRef(String recordId) {
        return new RecordRef(this, recordId);
    }

    public TypeLocation toTypeLocation() {
        return new TypeLocation(dbRef, collectionId);
    }
}
