package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DataApiRecord extends RecordIdSource {
    DataFields data();

    default RecordChange toInsertChange() {
        return RecordChange.toPutChange(RecordChangeType.INSERT, this);
    }

    default RecordChange toSetChange() {
        return RecordChange.toPutChange(RecordChangeType.SET, this);
    }

    default RecordChange toSetForcedChange() {
        return RecordChange.toSetForcedChange(this);
    }

    default RecordChange toUpdateChange() {
        return RecordChange.update(id(), data().toPutFieldChanges());
    }
}
