package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppRecordData;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class DataRecord extends DefaultObject implements RecordIdSource, VersionedDataApiRecord {
    public final DataApiUserId uid;

    public final DataRecordId id;

    public final long rev;

    @BenderFlatten
    protected final DataFields fields;

    public DataRecord(DataApiUserId uid, DataRecordId id, long rev, MapF<String, DataField> data) {
        this(uid, id, rev, new DataFields(data));
    }

    public DataRecord(DataApiUserId uid, DataRecordId id, long rev, DataFields data) {
        this.uid = uid;
        this.id = id;
        this.rev = rev;
        this.fields = data;
    }

    public DatabaseRecord toDatabaseRecord() {
        return new DatabaseRecord(id.handle.databaseId(), toSnapshotPojoRow());
    }

    public DataRecord withHandle(DatabaseHandle handle) {
        return new DataRecord(uid, new DataRecordId(handle, id.recordId), rev, fields);
    }

    public DataRecord withNewId(DataRecordId recordId) {
        return new DataRecord(uid, recordId, rev, fields);
    }

    public DataRecord withNewUid(DataApiUserId uid) {
        return new DataRecord(uid, id, rev, fields);
    }

    public DataRecord withNewRev(long rev) {
        return new DataRecord(uid, id, rev, fields);
    }

    public DataRecord withData(DataFields fields) {
        return new DataRecord(uid, id, rev, fields);
    }

    public String getDatabaseHandle() {
        return id.handle.handleValue();
    }

    public String getCollectionId() {
        return id.collectionId();
    }

    public String getRecordId() {
        return id.recordId();
    }

    public long getRev() {
        return rev;
    }

    public DataFields getFields() {
        return fields;
    }

    public MapF<String, DataField> getData() {
        return fields.data;
    }

    public DataSize getSize() {
        return fields.getRecordSize();
    }

    public SnapshotPojoRow toSnapshotPojoRow() {
        return new SnapshotPojoRow(getCollectionId(), getRecordId(), fields, rev);
    }

    public AppRecordData toAppRecordData() {
        return new AppRecordData(getRecordId(), rev, fields.data);
    }

    public MapF<String, DataField> getModifiableData() {
        return Cf.toHashMap(getData());
    }

    public ListF<ProtobufDataField> consProtobufFields() {
        return fields.toProtobufFields();
    }

    @Override
    public RecordId id() {
        return id;
    }

    public SimpleRecordId simpleId() {
        return id.recordId;
    }

    @Override
    public DataFields data() {
        return fields;
    }

    @Override
    public long rev() {
        return rev;
    }
}
