package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.DataNamesUtils;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataRecordId extends DefaultObject implements RecordId {
    public final DatabaseHandle handle;

    final SimpleRecordId recordId;

    public DataRecordId(DatabaseHandle handle, String collectionId, String recordId) {
        this(handle, new SimpleRecordId(collectionId, recordId));
    }

    public DataRecordId(DatabaseHandle handle, RecordId recordId) {
        this(handle, new SimpleRecordId(recordId));
        DataNamesUtils.validateId(recordId);
    }

    public DataRecordId(DatabaseHandle handle, SimpleRecordId recordId) {
        this.handle = handle;
        this.recordId = recordId;
    }

    @Override
    public String collectionId() {
        return recordId.collectionId();
    }

    @Override
    public String recordId() {
        return recordId.recordId();
    }

    public String handleValue() {
        return handle.handle;
    }
}
