package ru.yandex.chemodan.app.dataapi.api.data.record;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataField;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataRecordTest {
    final BenderMapper mapper = DataApiBenderUtils.mapper();

    @Test
    public void serializeToJson() {
        DataRecord record = new DataRecord(
                new DataApiPassportUserId(1L),
                new DataRecordId(new AppDatabaseRef("app", "dbId").consHandle("123456890"), "collection", "record"),
                1,
                new DataFields(
                        NamedDataField.integer("number", 123),
                        NamedDataField.bool("boolean", true),
                        NamedDataField.map("map",
                                Cf.<String, DataField>map()
                                        .plus1("string", DataField.string("str"))
                                        .plus1("infinity", DataField.infinity())
                        )
                )
        );

        Assert.equals(
                "{\"data\":{"
                        + "\"number\":{\"type\":\"integer\",\"value\":123}"
                        + ",\"boolean\":true"
                        + ",\"map\":{\"type\":\"map\",\"value\":{\"string\":\"str\",\"infinity\":{\"type\":\"+inf\"}}}"
                        + "}}",
                new String(mapper.serializeJson(record), CharsetUtils.UTF8_CHARSET));
    }
}
