package ru.yandex.chemodan.app.dataapi.api.data.record;

import java.util.LinkedHashMap;
import java.util.SortedMap;
import java.util.TreeMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByIdRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataRecords extends AbstractDataRecords {
    public static final DataRecords EMPTY = new DataRecords(Cf.list());

    public DataRecords(ListF<DataRecord> records) {
        super(records);
    }

    DataRecords(ModifiableDataRecords records) {
        super(records.records.unmodifiable());
    }

    private DataRecords(MapF<DataRecordId, DataRecord> records) {
        super(records);
    }

    public DataRecords filter(RecordsFilter filter) {
        return new DataRecords(records.filterValues(filter::matches));
    }

    public DataRecords withHandle(DatabaseHandle handle) {
        return new DataRecords(records.values().map(record -> record.withHandle(handle)));
    }

    public ModifiableDataRecords toModifiable(Option<ByIdRecordOrder> order) {
        return order.isPresent() ? toModifiableSortedBy(order.get()) : toModifiable();
    }

    private ModifiableDataRecords toModifiableSortedBy(ByIdRecordOrder order) {
        SortedMap<DataRecordId, DataRecord> sortedRecords = new TreeMap<>(order.recordIdComparator());
        sortedRecords.putAll(records);
        return new ModifiableDataRecords(Cf.x(sortedRecords));
    }

    private ModifiableDataRecords toModifiable() {
        return new ModifiableDataRecords(Cf.x(new LinkedHashMap<>(records)));
    }

    public ListF<SimpleDataRecord> toSimpleRecords() {
        return records.values().map(SimpleDataRecord::new);
    }

    public DataRecords mutate(Function<DataRecord, DataRecord> mutateF) {
        return new DataRecords(records().map(mutateF));
    }
}
