package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRevision;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author dbrylev
 */
@BenderBindAllFields
@ProtoMessage
public class DatabaseRecord {
    @ProtoField(n = 1)
    public final String databaseId;
    @ProtoField(n = 2)
    public final long rev;
    @BenderFlatten
    @ProtoField(n = 3)
    public final SnapshotPojoRow row;

    public DatabaseRecord(String databaseId, SnapshotPojoRow row) {
        this.databaseId = databaseId;
        this.rev = row.rev;
        this.row = row;
    }

    public String getRecordId() {
        return row.getRecordId();
    }

    public DatabaseRevision toDatabaseRevision() {
        return new DatabaseRevision(databaseId, rev);
    }
}
