package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;

/**
 * @author Denis Bakharev
 */
public interface Entity {
    CollectionRef collectionRef();

    String recordId();

    MapF<String, DataField> toDataMap();

    default SimpleDataRecord toFieldSet() {
        return toFieldSet(collectionRef());
    }

    default SimpleDataRecord toFieldSet(CollectionRef collectionRef) {
        return new SimpleDataRecord(
                collectionRef.consRecordRef(recordId()),
                toDataMap()
        );
    }
}
