package ru.yandex.chemodan.app.dataapi.api.data.record;

import javax.annotation.Nonnull;

import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface RecordId extends Comparable<RecordId>, RecordIdSource {
    String collectionId();

    String recordId();

    default DataRecordId toDataRecordId(DatabaseHandle handle) {
        return new DataRecordId(handle, this);
    }

    @Override
    default RecordId id() {
        return this;
    }

    default String idStr() {
        return collectionId() + "/" + recordId();
    }

    @Override
    default int compareTo(@Nonnull RecordId other) {
        int c1 = collectionId().compareTo(other.collectionId());
        if (c1 != 0) {
            return c1;
        }
        return recordId().compareTo(other.recordId());
    }
}
