package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RecordRef extends DefaultObject implements DatabaseRefSource, RecordId {
    public final CollectionRef colRef;

    public final String recordId;

    RecordRef(CollectionRef colRef, String recordId) {
        this.colRef = colRef;
        this.recordId = recordId;
    }

    @Override
    public DatabaseRef dbRef() {
        return colRef.dbRef();
    }

    public DataRecordId toRecordId(DatabaseHandle handle) {
        return new DataRecordId(handle, colRef.collectionId, recordId);
    }

    @Override
    public String collectionId() {
        return colRef.collectionId;
    }

    @Override
    public String recordId() {
        return recordId;
    }
}
