package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataField;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SimpleDataRecord extends DefaultObject implements DataApiRecord {
    public final RecordId recordId;
    public final DataFields data;

    public SimpleDataRecord(String collectionId, String recordId, NamedDataField... fields) {
        this(collectionId, recordId, new DataFields(fields));
    }

    public SimpleDataRecord(String collectionId, String recordId, DataFields fields) {
        this(new SimpleRecordId(collectionId, recordId), fields);
    }

    public SimpleDataRecord(RecordId recordId, MapF<String, DataField> data) {
        this(recordId, new DataFields(data));
    }

    public SimpleDataRecord(RecordId recordId, DataFields data) {
        this.recordId = recordId instanceof SimpleRecordId ? recordId : new SimpleRecordId(recordId);
        this.data = data;
    }

    public SimpleDataRecord(DataApiRecord record) {
        this(record.id(), record.data());
    }

    public SimpleDataRecord withRecordId(RecordId recordId) {
        return new SimpleDataRecord(recordId, data);
    }

    public SimpleDataRecord withData(DataFields data) {
        return new SimpleDataRecord(recordId, data);
    }

    @Override
    public RecordId id() {
        return recordId;
    }

    @Override
    public DataFields data() {
        return data;
    }

    public DataRecord toDataRecord(DataApiUserId uid, DatabaseHandle handle, long rev) {
        return new DataRecord(uid, recordId.toDataRecordId(handle), rev, data);
    }
}
