package ru.yandex.chemodan.app.dataapi.api.data.record;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class VersionedDataApiRecordImpl extends DefaultObject implements VersionedDataApiRecord {
    private final RecordId id;

    private final long rev;

    private final DataFields data;

    public VersionedDataApiRecordImpl(String collectionId, String recordId, long rev, DataFields data) {
        this(new SimpleRecordId(collectionId, recordId), rev, data);
    }

    public VersionedDataApiRecordImpl(RecordId id, long rev, DataFields data) {
        this.id = id;
        this.rev = rev;
        this.data = data;
    }

    @Override
    public RecordId id() {
        return id;
    }

    @Override
    public long rev() {
        return rev;
    }

    @Override
    public DataFields data() {
        return data;
    }
}
