package ru.yandex.chemodan.app.dataapi.api.data.snapshot;

import java.io.File;
import java.io.IOException;

import com.googlecode.zohhak.api.TestWith;
import com.googlecode.zohhak.api.runners.ZohhakRunner;
import org.junit.runner.RunWith;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecords;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltaUtilsTest;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 * @author Dmitriy Amelin (lemeh)
 */
@RunWith(ZohhakRunner.class)
public class PatchableSnapshotTest {
    private static final Logger logger = LoggerFactory.getLogger(PatchableSnapshotTest.class);

    private static final BenderMapper mapper = DataApiBenderUtils.mapper();

    public static final String FIXTURE_PATH_PATTERN = String.format(
            "%s/test_cases/%%s/%%s",
            DeltaUtilsTest.class
                    .getPackage()
                    .getName()
                    .replace('.', File.separatorChar));

    @TestWith(value = {
            "case1",
            "case2",
            "case3",
            "case4",
            "case5",
            "case6",
    })
    public void jsonTestCases(String caseName) throws IOException {
        logger.info("Reading test case {}", caseName);

        ListF<SnapshotPojoRow> rowsStart = readSnapshot(caseName, "input.json");
        Delta delta = readDelta(caseName);
        ListF<SnapshotPojoRow> rowsEnd = readSnapshot(caseName, "output.json")
                .map(row -> row.withRev(delta.changes.isNotEmpty() ? 1 : 0));

        logger.info("Checking test case {}", caseName);

        final DataApiUserId user = new DataApiPassportUserId(1L);
        final DatabaseHandle handle = DatabaseHandle.consGlobal("dbId", "handle");

        Database database = Database.consNew(user, handle);
        Function<SnapshotPojoRow, DataRecord> toDataRecordF = row -> row.toDataRecordWithRef(user, handle);
        DataRecords applied =
                new Snapshot(database, rowsStart.map(toDataRecordF))
                        .toPatchable()
                        .patch(delta)
                        .unmodifiable()
                        .records;
        Assert.equals(new DataRecords(rowsEnd.map(toDataRecordF)), applied);
    }

    public static Delta readDelta(String caseName) {
        return mapper.createParser(Delta.class)
                .parseJson(getFixtureInputStreamSource(caseName, "delta.json"));
    }

    public static ListF<SnapshotPojoRow> readSnapshot(String caseName, String filename) {
        return mapper.createParser(SnapshotPojoRow.class)
                .parseListJson(getFixtureInputStreamSource(caseName, filename));
    }

    private static InputStreamSource getFixtureInputStreamSource(String caseName, String filename) {
        String fixturePath = String.format(FIXTURE_PATH_PATTERN, caseName, filename);
        return new ClassPathResourceInputStreamSource(fixturePath);
    }
}
