package ru.yandex.chemodan.app.dataapi.api.data.snapshot;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByIdRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecords;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAlias;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class Snapshot extends DefaultObject {
    public final Database database;

    public final DataRecords records;

    public Snapshot(Database database, ListF<DataRecord> records) {
        this(database, new DataRecords(records));
    }

    public Snapshot(Database database, DataRecords records) {
        this.database = database;
        this.records = records;
    }

    public static Snapshot empty(Database database) {
        return new Snapshot(database, DataRecords.EMPTY);
    }

    public Snapshot withHandle(DatabaseHandle handle) {
        return new Snapshot(database.withHandle(handle), records.withHandle(handle));
    }

    public Snapshot withRecords(ListF<DataRecord> records) {
        return new Snapshot(database, records);
    }

    public Snapshot filterBy(RecordsFilter filter) {
        return new Snapshot(database, records.filter(filter));
    }

    public SetF<DataRecordId> recordIds() {
        return records.ids();
    }

    public CollectionF<DataRecord> records() {
        return records.records();
    }

    public int recordCount() {
        return records.recordCount();
    }

    public boolean isEmpty() {
        return records.isEmpty();
    }

    public boolean isNotEmpty() {
        return records.isNotEmpty();
    }

    public Option<DataRecord> getRecordO(DataRecordId id) {
        return records.getO(id);
    }

    public DataRecord getRecord(DataRecordId id) {
        return records.get(id);
    }

    public PatchableSnapshot toPatchable() {
        return new PatchableSnapshot(this);
    }

    public PatchableSnapshot toPatchable(Option<ByIdRecordOrder> order) {
        return new PatchableSnapshot(this, order);
    }

    public SnapshotPojo toPojo() {
        return SnapshotPojo.consFromRecords(database, records());
    }

    public Snapshot withoutRecords() {
        return new Snapshot(database, DataRecords.EMPTY);
    }

    public Snapshot withDatabaseAlias(DatabaseAlias databaseAlias) {
        return new Snapshot(database.withAlias(databaseAlias), records);
    }
}
