package ru.yandex.chemodan.app.dataapi.api.data.snapshot;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@ActionResultPojo
@Bendable
@ProtoMessage
public class SnapshotPojo extends DefaultObject {
    @BenderPart
    @ProtoField(n = 1)
    public final long rev;
    @BenderPart(name = "count")
    @ProtoField(n = 2)
    public final long recordsCount;

    @BenderPart(name = "created")
    @ProtoField(n = 3)
    public final Instant creationTime;
    @BenderPart(name = "modified")
    @ProtoField(n = 4)
    public final Instant modificationTime;
    @BenderPart
    @ProtoField(n = 5)
    public final long size;

    @BenderPart
    @ProtoField(n = 6)
    public final Option<String> description;
    @BenderPart
    @ProtoField(n = 7)
    public final ListF<SnapshotPojoRow> objects;

    @BenderPart
    @ProtoField(n = 9)
    public final String handle;

    @ProtoIgnoreField
    public final String databaseId;

    public SnapshotPojo(long rev, Database database, ListF<SnapshotPojoRow> objects) {
        this(rev, database.aliasId(), database.handleValue(), database.meta, objects);
    }

    public SnapshotPojo(long rev, String databaseId, String handle, DatabaseMeta meta, ListF<SnapshotPojoRow> objects) {
        this.rev = rev;
        this.objects = objects;

        this.creationTime = meta.creationTime;
        this.modificationTime = meta.modificationTime;
        this.size = meta.size.toBytes();
        this.recordsCount = meta.recordsCount;
        this.description = meta.description;
        this.databaseId = databaseId;
        this.handle = handle;
    }

    static SnapshotPojo consFromRecords(Database database, CollectionF<DataRecord> records) {
        ListF<SnapshotPojoRow> rows = records.map(DataRecord::toSnapshotPojoRow);
        return new SnapshotPojo(database.rev, database, rows);
    }

    public SnapshotPojo withRows(ListF<SnapshotPojoRow> rows) {
        return new SnapshotPojo(rev, databaseId, handle, getDatabaseMeta(), rows);
    }

    public Snapshot toDomainObject(DataApiUserId uid, DatabaseRef impliedDatabaseRef) {
        DatabaseHandle handle = consDatabaseHandle(impliedDatabaseRef);
        Database database = new Database(uid, handle, rev, getDatabaseMeta());
        ListF<DataRecord> records = objects.map(row -> row.toDataRecordWithRef(uid, handle));
        return new Snapshot(database, records);
    }

    private DatabaseMeta getDatabaseMeta() {
        return new DatabaseMeta(creationTime, modificationTime, DataSize.fromBytes(size), recordsCount, description);
    }

    private DatabaseHandle consDatabaseHandle(DatabaseRef impliedDatabaseRef) {
        ensureDbIdMatchesImpliedRef(impliedDatabaseRef);
        return impliedDatabaseRef
                .consHandle(handle);
    }

    private void ensureDbIdMatchesImpliedRef(DatabaseRef impliedDatabaseRef) {
        if (databaseId != null && !impliedDatabaseRef.databaseId().equals(databaseId)) {
            throw new IllegalArgumentException("Snapshot database id = " + databaseId +
                    " doesn't match implied database ref = " + impliedDatabaseRef);
        }
    }
}
