package ru.yandex.chemodan.app.dataapi.api.data.snapshot;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordIdSource;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@ActionResultPojo
@ProtoMessage
public class SnapshotPojoRow extends DefaultObject implements RecordIdSource {
    @BenderPart
    @ProtoField(n = 1)
    public final String collectionId;
    @BenderPart
    @ProtoField(n = 2)
    public final String recordId;
    @ProtoField(n = 3)
    public final long rev;
    @ProtoField(n = 4)
    public final ListF<ProtobufDataField> fields;

    @ProtoIgnoreField
    private final RecordId id;

    @ProtoIgnoreField
    private DataFields data;

    public SnapshotPojoRow(String collectionId, String recordId, DataFields data, long rev) {
        this.id = new SimpleRecordId(collectionId, recordId);
        this.collectionId = collectionId;
        this.recordId = recordId;
        this.data = data;
        this.rev = rev;
        this.fields = data.toProtobufFields();
    }

    public SnapshotPojoRow withRev(long rev) {
        return new SnapshotPojoRow(collectionId, recordId, data, rev);
    }

    public DataRecord toDataRecordWithRef(DataApiUserId uid, DatabaseHandle dbHandle) {
        return new DataRecord(uid, getRecordId(dbHandle), rev, getData());
    }

    @Override
    public RecordId id() {
        return id;
    }

    public DataRecordId getRecordId(DatabaseHandle databaseHandle) {
        return new DataRecordId(databaseHandle, collectionId, recordId);
    }

    public String getRecordId() {
        return recordId;
    }

    public DataSize getSize() {
        return getDataFieldsO()
                .map(DataFields::getRecordSize)
                .getOrElse(DataFields.EMPTY_RECORD_SIZE);
    }

    @BenderPart(name = "data")
    public MapF<String, DataField> getData() {
        return getDataFieldsO()
                .map(DataFields::data)
                .getOrNull();
    }

    private Option<DataFields> getDataFieldsO() {
        return Option.ofNullable(getDataFields());
    }

    private DataFields getDataFields() {
        if (data == null && fields != null) {
            data = DataFields.fromFieldsSource(fields);
        }
        return data;
    }

    @BenderPart(name = "data")
    private void setData(MapF<String, DataField> data) {
        this.data = new DataFields(data);
    }
}
