package ru.yandex.chemodan.app.dataapi.api.data.snapshot;

/**
 * @author dbrylev
 */
public class SnapshotWithSource {
    private final Snapshot snapshot;
    private final boolean isFromMds;

    private SnapshotWithSource(Snapshot snapshot, boolean isFromMds) {
        this.snapshot = snapshot;
        this.isFromMds = isFromMds;
    }

    public static SnapshotWithSource fromDb(Snapshot snapshot) {
        return new SnapshotWithSource(snapshot, false);
    }

    public static SnapshotWithSource fromMds(Snapshot snapshot) {
        return new SnapshotWithSource(snapshot, true);
    }

    public Snapshot getSnapshot() {
        return snapshot;
    }

    public String getSource() {
        return isFromMds ? "mds" : "db";
    }
}
