package ru.yandex.chemodan.app.dataapi.api.datasource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataSourceProperties {
    public static final DataSourceProperties DEFAULT = new DataSourceProperties();

    private final SetF<DataSourceTrait> traits;

    public DataSourceProperties(DataSourceTrait... traits) {
        this.traits = Cf.set(traits);
    }

    public boolean has(DataSourceTrait trait) {
        return traits.containsTs(trait);
    }
}
