package ru.yandex.chemodan.app.dataapi.api.datasource;

import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DataSourceRegistry extends DataSource {
    SpecificDataSource getDataSource(UserDatabaseSpec databaseSpec);

    @Override
    default DataSourceType type(UserDatabaseSpec databaseSpec) {
        return getDataSource(databaseSpec)
                .type(databaseSpec);
    }

    @Override
    default DataSourceSession openSession(UserDatabaseSpec databaseSpec) {
        return getDataSource(databaseSpec)
                .openSession(databaseSpec);
    }
}
