package ru.yandex.chemodan.app.dataapi.api.datasource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DataSourceSession {
    /**
     * BASIC CONTRACT
     */

    // metadata

    UserDatabaseSpec databaseSpec();


    // databases

    Database getOrCreateDatabase();

    Database createDatabase();

    Option<Database> getDatabaseO();

    void deleteDatabase(DatabaseDeletionMode deletionMode);

    void deleteDatabase(DatabaseDeletionMode deletionMode, ChunkRateLimiter rateLimiter);

    Database setDatabaseDescription(Option<String> newTitle);

    Database createDatabaseWithDescription(String title);

    Database fixDatabaseRevision(long rev, long currentRev);

    void onDatabaseUpdate(long rev);


    // deltas

    Delta getDelta(long rev);

    ListF<Delta> listDeltas(long fromRev, int limit);


    // snapshots and records

    Option<Snapshot> getSnapshotO(RecordsFilter filter);

    Option<ListF<DataRecord>> getDataRecordsO(RecordsFilter filter);

    ListF<DataRecord> getDataRecordsByIds(SetF<DataRecordId> recordIds);

    int getDataRecordsCount(RecordsFilter filter);


    // save changes

    void save(DatabaseChange change);

    default DsSessionTxManager tx() {
        return new NopSessionTxManager(this);
    }


    /**
     * DEFAULT METHODS
     */

    default DataApiUserId uid() {
        return databaseSpec().uid();
    }

    default DatabaseRef databaseRef() {
        return databaseSpec().databaseRef();
    }

    default DatabaseAlias databaseAlias() {
        return databaseSpec().databaseAlias();
    }

    default Database getDatabase() {
        return getDatabaseO()
                .getOrThrow(databaseRef()::consNotFound);
    }

    default ListF<DataRecord> getDataRecords(RecordsFilter filter) {
        return getDataRecordsO(filter)
                .getOrElse(Cf.list());
    }
}
