package ru.yandex.chemodan.app.dataapi.api.datasource;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DataSourceSessionDecorator extends DataSourceSession {
    DataSourceSession session();

    @Override
    default UserDatabaseSpec databaseSpec() {
        return session().databaseSpec();
    }

    @Override
    default Database getOrCreateDatabase() {
        return session().getOrCreateDatabase();
    }

    @Override
    default Database createDatabase() {
        return session().createDatabase();
    }

    @Override
    default Option<Database> getDatabaseO() {
        return session().getDatabaseO();
    }

    @Override
    default void deleteDatabase(DatabaseDeletionMode deletionMode) {
        session().deleteDatabase(deletionMode);
    }

    @Override
    default void deleteDatabase(DatabaseDeletionMode deletionMode, ChunkRateLimiter rateLimiter) {
        session().deleteDatabase(deletionMode, rateLimiter);
    }

    @Override
    default Database setDatabaseDescription(Option<String> newTitle) {
        return session().setDatabaseDescription(newTitle);
    }

    @Override
    default Database createDatabaseWithDescription(String title) {
        return session().createDatabaseWithDescription(title);
    }

    @Override
    default Database fixDatabaseRevision(long rev, long currentRev) {
        return session().fixDatabaseRevision(rev, currentRev);
    }

    @Override
    default void onDatabaseUpdate(long rev) {
        session().onDatabaseUpdate(rev);
    }

    @Override
    default Delta getDelta(long rev) {
        return session().getDelta(rev);
    }

    @Override
    default ListF<Delta> listDeltas(long fromRev, int limit) {
        return session().listDeltas(fromRev, limit);
    }

    @Override
    default ListF<DataRecord> getDataRecordsByIds(SetF<DataRecordId> recordIds) {
        return session().getDataRecordsByIds(recordIds);
    }

    @Override
    default Option<Snapshot> getSnapshotO(RecordsFilter filter) {
        return session().getSnapshotO(filter);
    }

    @Override
    default Option<ListF<DataRecord>> getDataRecordsO(RecordsFilter filter) {
        return session().getDataRecordsO(filter);
    }

    @Override
    default ListF<DataRecord> getDataRecords(RecordsFilter filter) {
        return session().getDataRecords(filter);
    }

    @Override
    default int getDataRecordsCount(RecordsFilter filter) {
        return session().getDataRecordsCount(filter);
    }

    @Override
    default void save(DatabaseChange change) {
        session().save(change);
    }

    @Override
    default DsSessionTxManager tx() {
        return session().tx();
    }
}
