package ru.yandex.chemodan.app.dataapi.api.datasource;

import ru.yandex.chemodan.app.dataapi.core.datasources.passport.PassportDataSource;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.YamoneyDatabaseDataSource;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum DataSourceType implements StringEnum {
    DISK("disk", DataSourceProperties.DEFAULT),
    YA_MONEY("ya-money", YamoneyDatabaseDataSource.DS_PROPS),
    PASSPORT("passport", PassportDataSource.DS_PROPS),
    YDB("ydb", DataSourceProperties.DEFAULT),
    ;

    private final String value;

    private final DataSourceProperties properties;

    DataSourceType(String value, DataSourceProperties properties) {
        this.value = value;
        this.properties = properties;
    }

    @Override
    public String value() {
        return value;
    }

    public boolean hasTrait(DataSourceTrait trait) {
        return properties.has(trait);
    }

    public static final StringEnumResolver<DataSourceType> R = StringEnumResolver.r(DataSourceType.class);
}
