package ru.yandex.chemodan.app.dataapi.api.datasource;

import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.dataapi.api.db.Database;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DsSessionTxManager {
    DataSourceSession session();

    <R> R executeInReadOnlyTx(Supplier<R> supplier);

    <R> R executeInReadCommittedTx(Supplier<R> supplier);

    <R> Option<R> executeInTxWithLockedDbIfDbExists(Function<Database, R> function);

    default void runInTxWithLockedDbIfDbExists(Function1V<Database> consumer) {
        executeInTxWithLockedDbIfDbExists(consumer.asFunctionReturnNull());
    }

    default <R> R executeInTxWithLockedDb(Function<Database, R> function) {
        return executeInTxWithLockedDbIfDbExists(function)
                .getOrThrow(() -> session().databaseRef().consNotFound());
    }
}
