package ru.yandex.chemodan.app.dataapi.api.datasource;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRefRevisions;
import ru.yandex.chemodan.app.dataapi.api.deltas.ModifiedRecordsPojo;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author tolmalev
 */
public interface ExtendedDataSource extends SpecificDataSource {
    ModifiedRecordsPojo getRecordsModifiedSinceRevisions(DataApiUserId uid, DatabaseRefRevisions sinceRevisions, Option<Integer> limitO);

    Option<Database> getDeletedDatabaseO(DataApiUserId uid, DatabaseHandle dbHandle);

    void completelyRemoveDatabasesDeletedBefore(Instant before);

    // admin-only
    ListF<Database> listDatabases(DataApiUserId uid);
    ListF<Database> listDeletedDatabases(DataApiUserId uid);
    void deleteDatabases(DataApiUserId uid, DatabasesFilterSource filterSrc, DatabaseDeletionMode mode);
    void deleteDatabases(DataApiUserId uid, DatabasesFilterSource filterSrc, DatabaseDeletionMode mode,
                         ChunkRateLimiter rateLimiter);

}
