package ru.yandex.chemodan.app.dataapi.api.datasource;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseAccessType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@RunWith(Parameterized.class)
public class ExternalDatabaseDataSourceSessionImplTest extends DataSourceSessionImplTest {
    @Autowired
    private ExternalDatabasesRegistry externalDatabasesRegistry;

    public ExternalDatabaseDataSourceSessionImplTest(DataSourceType type) {
        super(type);
    }

    @Override
    protected void setUpInternal() {
        Mockito
                .when(externalDatabasesRegistry.getExternalDatabaseAccessType(getExternalAlias()))
                .thenReturn(Option.of(DatabaseAccessType.READ_WRITE));
    }

    @Override
    protected DatabaseAlias getDatabaseAlias() {
        return getExternalAlias();
    }

    private ExternalDatabaseAlias getExternalAlias() {
        return new ExternalDatabaseAlias(new DatabaseAppContext("externalApp"), getAppDatabaseRef());
    }
}
