package ru.yandex.chemodan.app.dataapi.api.datasource;

import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class NopSessionTxManager implements DsSessionTxManager {
    private final DataSourceSession session;

    public NopSessionTxManager(DataSourceSession session) {
        this.session = session;
    }

    @Override
    public DataSourceSession session() {
        return session;
    }

    @Override
    public <R> R executeInReadOnlyTx(Supplier<R> supplier) {
        return supplier.get();
    }

    @Override
    public <R> R executeInReadCommittedTx(Supplier<R> supplier) {
        return supplier.get();
    }

    @Override
    public <R> Option<R> executeInTxWithLockedDbIfDbExists(Function<Database, R> function) {
        return session.getDatabaseO()
                .map(function::apply);
    }
}
