package ru.yandex.chemodan.app.dataapi.api.db;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class DatabaseExistsException extends A3Exception implements HttpStatusCodeSourceWithErrorLevel {
    public DatabaseExistsException(String message) {
        super(ErrorNames.ALREADY_EXISTS, message);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }
}
