package ru.yandex.chemodan.app.dataapi.api.db.filter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabasesFilterOrAll extends DefaultObject implements DatabaseContextSource {
    private static final DatabasesFilterOrAll ALL = new DatabasesFilterOrAll(Option.empty());

    private final Option<DatabasesFilter> filterO;

    DatabasesFilterOrAll(DatabasesFilter filter) {
        this(Option.of(filter));
    }

    public static DatabasesFilterOrAll all() {
        return ALL;
    }

    private DatabasesFilterOrAll(Option<DatabasesFilter> filterO) {
        this.filterO = filterO;
    }

    public boolean isAll() {
        return !filterO.isPresent();
    }

    public Type getType() {
        return filterO.map(Type::byFilterType)
                .getOrElse(Type.ALL);
    }

    @Override
    public DatabaseContext dbContext() {
        return filter().dbContext();
    }

    public Option<String> appNameO() {
        return filter().appNameO();
    }

    public ListF<String> databaseIds() {
        return filter().databaseIds();
    }

    private DatabasesFilter filter() {
        return filterO.get();
    }

    public enum Type {
        CONTEXT, REFS, REVS, ALL;

        static final MapF<DatabasesFilter.Type, Type> MAPPING = Cf.map(
                DatabasesFilter.Type.CONTEXT, CONTEXT,
                DatabasesFilter.Type.REFS, REFS,
                DatabasesFilter.Type.REVS, REVS
        );

        static Type byFilterType(DatabasesFilter filter) {
            return MAPPING.getTs(filter.type());
        }
    }
}
