package ru.yandex.chemodan.app.dataapi.api.db.handle;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseHandle extends DefaultObject implements DatabaseRefSource {
    public final DatabaseRef dbRef;

    public final String handle;

    public DatabaseHandle(DatabaseRefSource dbRefSrc, String handle) {
        this(dbRefSrc.dbRef(), handle);
    }

    public DatabaseHandle(DatabaseRef dbRef, String handle) {
        this.dbRef = dbRef;
        this.handle = handle;
    }

    public DatabaseHandle(String app, String databaseId, String handle) {
        this(new AppDatabaseRef(app, databaseId), handle);
    }

    DatabaseHandle(DatabaseContext context, Tuple2<String, String> dbIdWithHandle) {
        this(context, dbIdWithHandle.get1(), dbIdWithHandle.get2());
    }

    private DatabaseHandle(DatabaseContext context, String databaseId, String handle) {
        this(context.consDbRef(databaseId), handle);
    }

    public static DatabaseHandle consGlobal(String databaseId, String handle) {
        return new DatabaseHandle(DatabaseContext.global(), databaseId, handle);
    }

    public static DatabaseHandle fromAppDbId(Option<String> appDbId, String databaseId, String handle) {
        return new DatabaseHandle(
                DatabaseContext.fromDbAppId(appDbId)
                        .consDbRef(databaseId),
                handle
        );
    }

    @Override
    public DatabaseRef dbRef() {
        return dbRef;
    }

    public DatabaseHandle withDbRef(DatabaseRef dbRef) {
        return dbRef.consHandle(handle);
    }

    public String handleValue() {
        return handle;
    }
}
