package ru.yandex.chemodan.app.dataapi.api.db.handle;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseHandleRevision extends DefaultObject {
    final DatabaseHandle handle;

    final long rev;

    public DatabaseHandleRevision(DatabaseHandle handle, long rev) {
        this.handle = handle;
        this.rev = rev;
    }

    public DatabaseHandleRevision inc() {
        return new DatabaseHandleRevision(handle, rev + 1);
    }

    Tuple2<String, Long> toHandleRevisionTuple() {
        return new Tuple2<>(handle.handle, this.rev);
    }

    public DatabaseHandle handle() {
        return handle;
    }
}
