package ru.yandex.chemodan.app.dataapi.api.db.handle;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextHolder;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseHandleRevisions extends DatabaseContextHolder {
    private final ListF<DatabaseHandleRevision> revisions;

    public DatabaseHandleRevisions(DatabaseContextSource ctxSrc, ListF<DatabaseHandleRevision> revisions) {
        super(ctxSrc);
        this.revisions = revisions;
    }

    public DatabaseHandleRevisions inc() {
        return new DatabaseHandleRevisions(context, revisions.map(DatabaseHandleRevision::inc));
    }

    public Tuple2List<String, Long> toHandleRevisionTuples() {
        return Tuple2List.tuple2List(revisions.map(DatabaseHandleRevision::toHandleRevisionTuple));
    }

    public boolean isEmpty() {
        return revisions.isEmpty();
    }

    public ListF<DatabaseHandle> handles() {
        return revisions.map(DatabaseHandleRevision::handle);
    }

}
