package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AppDatabaseRef extends DatabaseRef implements AppDatabaseRefSource {
    public final DatabaseAppContext context;

    public AppDatabaseRef(String appName, String databaseId) {
        this(new DatabaseAppContext(appName), databaseId);
    }

    public AppDatabaseRef(DatabaseAppContext context, String databaseId) {
        super(databaseId);
        this.context = context;
    }

    @Override
    public DatabaseAppContext dbContext() {
        return context;
    }
}
