package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DatabaseAlias {
    DatabaseAliasType aliasType();

    String aliasId();

    DatabaseRef dbRef();

    static DatabaseAlias parse(String appName, String databaseId) {
        return parse(Option.of(appName), databaseId);
    }

    static DatabaseAlias parse(Option<String> appNameO, String databaseId) {
        return parse(DatabaseContext.cons(appNameO), databaseId);
    }

    static DatabaseAlias parse(DatabaseContext context, String databaseId) {
        return Option.<DatabaseAlias>empty()
                .orElse(() -> IndirectDatabaseAlias.parseIndirectO(context, databaseId).uncheckedCast())
                .getOrElse(() -> context.consDbRef(databaseId));
    }
}
