package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.DataNamesUtils;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseExistsException;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.DatabaseNotFoundException;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class DatabaseRef extends DefaultObject implements DatabaseRefSource, DatabaseAlias {

    private final String databaseId;

    protected DatabaseRef(String databaseId) {
        this.databaseId = databaseId;
    }

    public static DatabaseRef cons(Option<String> appNameO, String databaseId) {
        return DatabaseContext.cons(appNameO)
                .consDbRef(databaseId);
    }

    @Override
    public DatabaseAliasType aliasType() {
        return DatabaseAliasType.DIRECT;
    }

    @Override
    public abstract DatabaseContext dbContext();

    @Override
    public DatabaseRef dbRef() {
        return this;
    }

    @Override
    public final String databaseId() {
        return databaseId;
    }

    public String aliasId() {
        return databaseId();
    }

    @Override
    public String toString() {
        return String.format("%s.%s", dbContext(), databaseId());
    }

    public CollectionRef consColRef(String collectionId) {
        return CollectionRef.cons(this, collectionId);
    }

    public CollectionRef consColRefWithDbId() {
        return CollectionRef.cons(this, databaseId());
    }

    public DatabaseHandle consHandle(String handle) {
        return new DatabaseHandle(this, handle);
    }

    @Override
    public NotFoundException consNotFound() {
        return DatabaseNotFoundException.cons(this);
    }

    @Override
    public NotFoundException consNotFoundDueToMissing(DataApiUserId uid) {
        return DatabaseNotFoundException.consDueToUser(uid, this);
    }

    @Override
    public DatabaseExistsException consExistsException() {
        return new DatabaseExistsException("Database " + this + " exists");
    }

    public void validate() {
        DataNamesUtils.validateId(databaseId());
    }
}
