package ru.yandex.chemodan.app.dataapi.api.db.ref;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseRefMarshallerUnmarshaller extends ToFieldMarshallerSupport
        implements ToFieldWithCallbackMarshaller, JsonFieldLevelUnmarshaller
{
    private static final BenderParserSerializer<DatabaseRefPojo> parserSerializer =
            Bender.cons(ClassX.wrap(DatabaseRefPojo.class));

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        parserSerializer.getSerializer()
                .serializeJson(new DatabaseRefPojo((DatabaseRef) fieldValue), writer, context);
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        return parserSerializer.getParser()
                .parseJsonO(node, context)
                .map(DatabaseRefPojo::toDatabaseRef)
                .map(pojo -> pojo);
    }

    @Override
    public void writeJsonToFieldWithCallback(BenderJsonWriter writer, Object fieldValue,
            PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        writeJsonToField(writer, fieldValue, context);
    }

    @Override
    public void writeXmlToFieldWithCallback(XmlWriter writer, Object fieldValue, PojoMarshallingXmlCallback callback,
            MarshallerContext context)
    {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }

    @Bendable
    private static class DatabaseRefPojo {
        @BenderPart(name = "app")
        final Option<String> app;

        @BenderPart(name = "db")
        final String databaseId;

        DatabaseRefPojo(DatabaseRef dbRef) {
            this(dbRef.appNameO(), dbRef.databaseId());
        }

        DatabaseRefPojo(Option<String> app, String databaseId) {
            this.app = app;
            this.databaseId = databaseId;
        }

        DatabaseRef toDatabaseRef() {
            return DatabaseContext.cons(app)
                    .consDbRef(databaseId);
        }
    }
}
