package ru.yandex.chemodan.app.dataapi.api.db.ref;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseRefMarshallerUnmarshallerTest {
    private static final BenderParserSerializer<DatabaseRef> parserSerializer =
            BenderParserSerializer.cons(
                    ClassX.wrap(DatabaseRef.class),
                    new BenderConfiguration(
                            new BenderSettings(),
                            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                                    .add(DatabaseRef.class,
                                            new DatabaseRefMarshallerUnmarshaller(),
                                            new DatabaseRefMarshallerUnmarshaller())
                                    .build()
                    )
            );

    @Test
    public void serializeAppRef() {
        Assert.assertEquals(
                "{\"app\":\"some app name\",\"db\":\"some db name\"}",
                serialize(new AppDatabaseRef("some app name", "some db name"))
        );
    }

    @Test
    public void serializeGlobalRef() {
        Assert.assertEquals(
                "{\"db\":\"some db name\"}",
                serialize(new GlobalDatabaseRef("some db name"))
        );
    }

    @Test
    public void parseAppRef() {
        Assert.assertEquals(
                new AppDatabaseRef("some app name", "some db name"),
                parse("{\"app\":\"some app name\",\"db\":\"some db name\"}")
        );
    }

    @Test
    public void parseGlobalRef() {
        Assert.assertEquals(
                new GlobalDatabaseRef("some db name"),
                parse("{\"db\":\"some db name\"}")
        );
    }

    private String serialize(DatabaseRef dbRef) {
        return new String(parserSerializer.getSerializer()
                .serializeJson(dbRef));
    }

    private DatabaseRef parse(String json) {
        return parserSerializer.getParser()
                .parseJson(json);
    }
}
