package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseExistsException;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DatabaseRefSource extends DatabaseContextSource, DatabaseRefsSource {
    DatabaseRef dbRef();

    @Override
    default DatabaseRefs dbRefs() {
        return new DatabaseRefs(dbRef());
    }

    @Override
    default DatabaseContext dbContext() {
        return dbRef().dbContext();
    }

    default String databaseId() {
        return dbRef().databaseId();
    }

    default void validate() {
        dbRef().validate();
    }

    default boolean refersDbMatching(DatabaseRefSource otherSrc) {
        return dbRef().equals(otherSrc.dbRef());
    }

    default NotFoundException consNotFound() {
        return dbRef().consNotFound();
    }

    default NotFoundException consNotFoundDueToMissing(DataApiUserId uid) {
        return dbRef().consNotFoundDueToMissing(uid);
    }

    default DatabaseExistsException consExistsException() {
        return dbRef().consExistsException();
    }
}
