package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IterableF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextHolder;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseRefs extends DatabaseContextHolder implements DatabaseRefsSource, IterableF<DatabaseRef> {
    public final ListF<String> databaseIds;

    public DatabaseRefs(DatabaseRef dbRef) {
        this(dbRef.dbContext(), Cf.list(dbRef.databaseId()));
    }

    public DatabaseRefs(DatabaseContext context, String... databaseIds) {
        this(context, Cf.list(databaseIds));
    }

    public DatabaseRefs(Option<String> appNameO, ListF<String> databaseIds) {
        this(DatabaseContext.cons(appNameO), databaseIds);
    }

    public DatabaseRefs(DatabaseContextSource contextSrc, ListF<String> databaseIds) {
        super(contextSrc);
        this.databaseIds = databaseIds;
    }

    public static DatabaseRefs cons(DatabaseRef firstRef, DatabaseRef... additionalRefs) {
        DatabaseContext context = firstRef.dbContext();
        ListF<DatabaseRef> dbRefs = Cf.list(firstRef).plus(additionalRefs);
        if (!dbRefs.forAll(dbRef -> dbRef.dbContext().equals(context))) {
            throw new IllegalArgumentException("Context MUST be the same for all database refs");
        }

        return new DatabaseRefs(context, dbRefs.map(DatabaseRef::databaseId));
    }

    public static DatabaseRefs global(ListF<String> databaseIds) {
        return new DatabaseRefs(DatabaseContext.global(), databaseIds);
    }

    public static DatabaseRefs empty(DatabaseContextSource ctxSrc) {
        return new DatabaseRefs(ctxSrc, Cf.list());
    }

    @Override
    public DatabaseRefs dbRefs() {
        return this;
    }

    @Override
    public IteratorF<DatabaseRef> iterator() {
        return databaseIds.iterator()
                .map(context::consDbRef);
    }

    @Override
    public boolean isEmpty() {
        return databaseIds.isEmpty();
    }

    @Override
    public ListF<String> getDatabaseIds() {
        return databaseIds;
    }

    @Override
    public Function1B<DatabaseRefSource> excludeF() {
        return includeF().notF();
    }

    private Function1B<DatabaseRefSource> includeF() {
        final ListF<String> databaseIds = getDatabaseIds();
        return refSrc -> databaseIds.containsTs(refSrc.databaseId());
    }
}
