package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilter;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandlesOptionSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DatabaseRefsSource extends DatabaseContextSource, DatabaseHandlesOptionSource, DatabasesFilterSource {
    DatabaseRefs dbRefs();

    @Override
    default DatabaseContext dbContext() {
        return dbRefs().dbContext();
    }

    @Override
    default Option<DatabaseHandles> dbHandlesO() {
        return Option.empty();
    }

    default boolean isEmpty() {
        return dbRefs().isEmpty();
    }

    default ListF<String> getDatabaseIds() {
        return dbRefs().getDatabaseIds();
    }

    default Function1B<DatabaseRefSource> excludeF() {
        return dbRefs().excludeF();
    }

    @Override
    default DatabasesFilter toDbsFilter() {
        return new DatabasesFilter(this);
    }
}
