package ru.yandex.chemodan.app.dataapi.api.db.ref;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.db.ref.internalpublic.PublicDatabaseAlias;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Data
public abstract class IndirectDatabaseAlias implements DatabaseAlias {
    private final AppDatabaseRef appRef;
    private final String aliasId;

    protected IndirectDatabaseAlias(AppDatabaseRef appRef) {
        this.appRef = appRef;
        this.aliasId = generateId(aliasPrefix(), appRef.appName(), appRef.databaseId());
    }

    protected static String generateId(String aliasPrefix, String appName, String databaseId) {
        return "." + aliasPrefix + "." + appName + "@" + databaseId; //".%s.%s@%s"
    }

    static Option<? extends IndirectDatabaseAlias> parseIndirectO(DatabaseContext context, String databaseId) {
        return Option.<IndirectDatabaseAlias>empty()
                .orElse(() -> parseExternalO(context, databaseId))
                .orElse(() -> parsePublicO(context, databaseId));
    }

    private static Option<IndirectDatabaseAlias> parseExternalO(DatabaseContext context, String databaseId) {
        return ExternalDatabaseAlias.parseO(context, databaseId)
                .uncheckedCast();
    }

    private static Option<IndirectDatabaseAlias> parsePublicO(DatabaseContext context, String databaseId) {
        return PublicDatabaseAlias.parseO(context, databaseId)
                .uncheckedCast();
    }

    protected abstract String aliasPrefix();

    @Override
    public String aliasId() {
        return aliasId;
    }

    @Override
    public AppDatabaseRef dbRef() {
        return appRef;
    }

    @Override
    public String toString() {
        return aliasId();
    }
}
