package ru.yandex.chemodan.app.dataapi.api.db.ref;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author dbrylev
 */
public class SpecialDatabases {
    private static final DynamicProperty<ListF<String>> hackDeleteAllowed =
            new DynamicProperty<>("hack-delete-dbs", Cf.list());

    private static final DynamicProperty<ListF<String>> mdsSnapshotable =
            new DynamicProperty<>("mds-snapshotable-dbs", Cf.list("smartcache:photoslice"));

    private static final DynamicProperty<ListF<String>> recordsPartialIndexed =
            new DynamicProperty<>("partial-indexed-records-dbs", Cf.list("lenta:lenta_blocks"));


    public static boolean isHackDeleteAllowed(DatabaseRef ref) {
        return hackDeleteAllowed.get().containsTs(dbKey(ref));
    }

    public static boolean isMdsSnapshotable(DatabaseRef ref) {
        return MDS_SNAPSHOTABLE_ANY || mdsSnapshotable.get().containsTs(dbKey(ref));
    }

    public static boolean isDataRecordsPartialIndexed(DatabaseRef ref) {
        return recordsPartialIndexed.get().containsTs(dbKey(ref));
    }

    private static String dbKey(DatabaseRef ref) {
        return String.format("%s:%s", ref.appNameO().getOrElse(""), ref.databaseId());
    }


    private static boolean MDS_SNAPSHOTABLE_ANY = false;

    public static void setMdsSnapshotableAnyForTest(boolean any) {
        MDS_SNAPSHOTABLE_ANY = any;
    }
}
