package ru.yandex.chemodan.app.dataapi.api.db.ref.external;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAliasType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.IndirectDatabaseAlias;
import ru.yandex.chemodan.app.dataapi.web.AccessForbiddenException;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author tolmalev
 */
public class ExternalDatabaseAlias extends IndirectDatabaseAlias {
    private static final String aliasPrefix = "ext";
    private static final Pattern2 idPattern = Pattern2.compile("^\\." + aliasPrefix + "\\.([^@]+)@(.+)$");

    private final DatabaseAppContext clientContext;

    public ExternalDatabaseAlias(String clientAppName, String appName, String databaseId) {
        this(new DatabaseAppContext(clientAppName), new AppDatabaseRef(appName, databaseId));
    }

    public ExternalDatabaseAlias(DatabaseAppContext clientContext, AppDatabaseRef databaseRef) {
        super(databaseRef);
        this.clientContext = clientContext;
    }

    public static Option<ExternalDatabaseAlias> parseO(DatabaseContext context, String databaseId) {
        return idPattern.findFirst(databaseId)
                .map(matcher -> new AppDatabaseRef(matcher.group(1), matcher.group(2)))
                .map(dbRef -> consUnsafe(context, dbRef));
    }

    private static ExternalDatabaseAlias consUnsafe(DatabaseContext context, AppDatabaseRef databaseRef) {
        DatabaseAppContext appContext = context.appContextO()
                .getOrThrow(() -> new AccessForbiddenException("Access forbidden for external database " + databaseRef));
        return new ExternalDatabaseAlias(appContext, databaseRef);
    }

    @Override
    public DatabaseAliasType aliasType() {
        return DatabaseAliasType.EXTERNAL;
    }

    @Override
    protected String aliasPrefix() {
        return aliasPrefix;
    }

    public String clientAppName() {
        return clientContext.appName();
    }

    public static String generateId(String appName, String databaseId) {
        return generateId(aliasPrefix, appName, databaseId);
    }
}
