package ru.yandex.chemodan.app.dataapi.api.db.ref.external;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAlias;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class ExternalDatabaseAliasTest {
    @Test
    public void parse() {
        DatabaseAlias alias = DatabaseAlias.parse("client-app", ".ext.app@dbId");
        Assert.isInstance(alias, ExternalDatabaseAlias.class);
        Assert.equals(new ExternalDatabaseAlias("client-app", "app", "dbId"), alias);
    }

    @Test
    public void alias() {
        Assert.equals(".ext.app@dbId", new ExternalDatabaseAlias("client-app", "app", "dbId").aliasId());
    }

    @Test
    public void parseSerialize() {
        for (Integer ignored : Cf.range(0, 100)) {
            String clientAppName = Random2.R.nextAlnum(10);
            String appName = Random2.R.nextAlnum(10);
            String databaseId = Random2.R.nextAlnum(60);

            System.out.print("Test for app = " + appName + ", dbId = " + databaseId);

            ExternalDatabaseAlias extAlias = new ExternalDatabaseAlias(clientAppName, appName, databaseId);
            Assert.equals(extAlias, DatabaseAlias.parse(clientAppName, extAlias.aliasId()));
        }
    }
}
