package ru.yandex.chemodan.app.dataapi.api.db.ref.external;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 */
@Configuration
public class ExternalDatabasesContextConfiguration {
    @Bean
    public ExternalDatabasesRegistry externalDatabasesRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager)
    {
        ExternalDatabasesRegistry registry =
                new ExternalDatabasesRegistry(zkRoot.child("external_databases"));
        zkManager.addClient(registry);
        return registry;
    }
}
