package ru.yandex.chemodan.app.dataapi.api.db.ref.internalpublic;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAliasType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.IndirectDatabaseAlias;
import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author metal
 * @author Dmitriy Amelin (lemeh)
 */
public class PublicDatabaseAlias extends IndirectDatabaseAlias {
    public static final String aliasPrefix = "pub";
    private static final Pattern2 idPattern = Pattern2.compile("^\\." + aliasPrefix + "\\.((.+)@)?([^@]+)$");

    public PublicDatabaseAlias(String app, String databaseId) {
        this(new AppDatabaseRef(app, databaseId));
    }

    public PublicDatabaseAlias(AppDatabaseRef internalRef) {
        super(internalRef);
    }

    public static Option<PublicDatabaseAlias> parseO(DatabaseContext context, String databaseId) {
        Matcher2 matcher = idPattern.matcher2(databaseId);
        return Option.when(matcher.matches(),
                () -> consUnsafe(context, matcher.group(2), matcher.group(3).get())
        );
    }

    private static PublicDatabaseAlias consUnsafe(DatabaseContext context, Option<String> parsedAppO, String databaseId) {
        DatabaseAppContext appContext = context.appContextO()
                .orElse(() -> parsedAppO.map(DatabaseAppContext::new))
                .getOrThrow(() -> new IllegalArgumentException("Expecting app context for public ref, got user"));
        return new PublicDatabaseAlias(appContext.consDbRef(databaseId));
    }

    @Override
    public DatabaseAliasType aliasType() {
        return DatabaseAliasType.PUBLIC;
    }

    @Override
    protected String aliasPrefix() {
        return aliasPrefix;
    }

    public DatabaseHandle consHandle() {
        return dbRef().consHandle("public." + dbRef().databaseId());
    }
}
