package ru.yandex.chemodan.app.dataapi.api.db.ref.internalpublic;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class PublicDatabaseAliasTest {
    @Test
    public void parseCorrectWithoutApp() {
        DatabaseAppContext appContext = new DatabaseAppContext("app");
        PublicDatabaseAlias publicDatabaseAlias = PublicDatabaseAlias.parseO(appContext, ".pub.dbid").get();
        Assert.equals(new AppDatabaseRef("app", "dbid"), publicDatabaseAlias.dbRef());
    }

    @Test
    public void parseCorrectWithApp() {
        PublicDatabaseAlias publicDatabaseAlias = parse(".pub.appid@dbid");
        Assert.equals(new AppDatabaseRef("appid", "dbid"), publicDatabaseAlias.dbRef());
    }

    @Test
    public void parseIncorrectWithoutApp() {
        Assert.none(parseO("different_dbid"));
    }

    @Test
    public void parseIncorrectWithApp() {
        Assert.none(parseO(".pub.@dbid"));
    }

    @Test
    public void parseIncorrectWithoutDbId() {
        Assert.none(parseO(".pub.appid@"));
    }

    @Test
    public void createDatabaseHandle() {
        Assert.equals("public.dbid", parse(".pub.appid@dbid").consHandle().handleValue());
    }

    @Test
    public void alias() {
        Assert.equals(".pub.app@dbId", new PublicDatabaseAlias(new AppDatabaseRef("app", "dbId")).aliasId());
    }

    private PublicDatabaseAlias parse(String databaseId) {
        return parseO(databaseId).get();
    }

    private Option<PublicDatabaseAlias> parseO(String databaseId) {
        return PublicDatabaseAlias.parseO(DatabaseContext.global(), databaseId);
    }
}
