package ru.yandex.chemodan.app.dataapi.api.db.revision;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextHolder;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.data.record.DatabaseRecord;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilter;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandleRevisions;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefs;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefsSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseRefRevisions extends DatabaseContextHolder implements DatabasesFilterSource, DatabaseRefsSource {
    final ListF<DatabaseRevision> revisions;

    public DatabaseRefRevisions(DatabaseContextSource contextSrc, ListF<DatabaseRevision> revisions) {
        super(contextSrc);
        this.revisions = revisions;
    }

    public DatabaseHandleRevisions zipWith(DatabaseHandles handles) {
        if (handles.isEmpty()) {
            return new DatabaseHandleRevisions(this, Cf.list());
        }

        return new DatabaseHandleRevisions(
                this,
                revisions.filterMap(
                        rev -> handles.byDatabaseIdO(rev.getDatabaseId())
                                .map(rev::toHandleRevision)
                )
        );
    }

    @Override
    public DatabaseRefs dbRefs() {
        return new DatabaseRefs(dbContext(), revisions.map(DatabaseRevision::getDatabaseId));
    }

    @Override
    public DatabasesFilter toDbsFilter() {
        return new DatabasesFilter(this);
    }

    public ListF<DatabaseRevision> revisions() {
        return revisions;
    }

    public ListF<DatabaseRevision> withLatestFrom(ListF<DatabaseRecord> records) {
        MapF<String, DatabaseRevision> latestRevisions = records.map(DatabaseRecord::toDatabaseRevision)
                        .toMapMappingToKey(DatabaseRevision::getDatabaseId);
        return revisions.map(
                revision ->
                        latestRevisions.getO(revision.getDatabaseId())
                                .getOrElse(revision)
        );
    }
}
