package ru.yandex.chemodan.app.dataapi.api.db.revision;

import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandleRevision;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
@ProtoMessage
public class DatabaseRevision {
    @ProtoField(n = 1)
    private final String databaseId;
    @ProtoField(n = 2)
    private final long rev;

    public DatabaseRevision(String databaseId, long rev) {
        this.databaseId = databaseId;
        this.rev = rev;
    }

    public String getDatabaseId() {
        return databaseId;
    }

    public long getRev() {
        return rev;
    }

    public DatabaseHandleRevision toHandleRevision(DatabaseHandle handle) {
        return new DatabaseHandleRevision(handle, rev);
    }
}
