package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.SpecialDatabases;
import ru.yandex.chemodan.app.dataapi.web.DeltasGoneException;
import ru.yandex.misc.lang.Check;

/**
 * @author tolmalev
 */
public class DeltaUtils {
    public static Option<RecordChange> findNonExistingRecordDeletionOrUpdate(DatabaseHandle handle,
            CollectionF<DataRecord> currentRecords, ListF<Delta> deltas)
    {
        boolean allowDeleteNonExisting = SpecialDatabases.isHackDeleteAllowed(handle.dbRef());
        SetF<DataRecordId> existingIds = Cf.toHashSet(currentRecords.map(r -> r.id));
        for (Delta delta : deltas) {
            for (RecordChange change : delta.changes) {
                RecordChangeType type = change.type;
                DataRecordId recordId = change.getRecordId(handle);

                switch(type) {
                    case UPDATE:
                    case DELETE:
                        // special case
                        if (allowDeleteNonExisting && type == RecordChangeType.DELETE) {
                            continue;
                        }

                        if (existingIds.containsTs(recordId)) {
                            continue;
                        }

                        return Option.of(change);

                    case INSERT:
                    case SET:
                        existingIds.add(recordId);
                        continue;

                    default:
                        Check.fail("Unknown change type " + change.type);
                }
            }
        }
        return Option.empty();
    }

    public static class RevSequenceChecker {
        private long revision;

        public RevSequenceChecker(long revision) {
            this.revision = revision;
        }

        public boolean matches(Delta delta) {
            return revision++ == delta.rev.get();
        }

        public void check(Delta delta) {
            if (!matches(delta)) {
                throw new DeltasGoneException();
            }
        }
    }
}
